export const state = () => ({
  getAllCourses: {},
  getAllCategories: {},
  countCart: null,
  getCarts: {},
  discount_info: {},
  getHomeData: {},
  getMainCategories: [],
  getStudentFeedback: {},
  getTrendyCourses: [],
  getWishLists: [],
  getWishListCount: {},
  getCertificationFind: {},
  getStudentCourseReport: {},
  getStudentPurchaseCourses: {},
  getStudentCourseSingle: {},
  getAboutPage: {},
  getCertificationPage: {},
  getFaqQues: [],
  getContactInfo: {},
  getStudentFeedbackPage: {},
  getAllCertificates: {},
  getStudentProfile: {},
  getSubCategoryWithCourses: [],
  getCategoryWithCourses: [],
  getPartner: [],
  getCourseDetails: [],
  getContactUs: {},
  getTrendyCategory: [],
  getCategoryData: {},
  getMainCategoryExpand: {},
  getSubCategoryExpand: {},
  getTeacherCourses: {},
  getCourses: {},
  getCurrentLearning: {},
  getPopUpBanner: {},
  getHeaderBanner:{}
});

export const getters = {
  getAllCourses(state) {
    return state.getAllCourses;
  },
  getAllCategories(state) {
    return state.getAllCategories;
  },
  countCart(state) {
    return state.countCart;
  },
  getCarts(state) {
    return state.getCarts;
  },
  discount_info(state) {
    return state.discount_info;
  },
  getHomeData(state) {
    return state.getHomeData;
  },
  getMainCategories(state) {
    return state.getMainCategories;
  },
  getStudentFeedback(state) {
    return state.getStudentFeedback;
  },
  getTrendyCourses(state) {
    return state.getTrendyCourses;
  },
  getWishLists(state) {
    return state.getWishLists;
  },
  getWishListCount(state) {
    return state.getWishListCount;
  },
  getCertificationFind(state) {
    return state.getCertificationFind;
  },
  getStudentCourseReport(state) {
    return state.getStudentCourseReport;
  },
  getStudentPurchaseCourses(state) {
    return state.getStudentPurchaseCourses;
  },
  getAboutPage(state) {
    return state.getAboutPage;
  },
  getStudentCourseSingle(state) {
    return state.getStudentCourseSingle;
  },
  getCertificationPage(state) {
    return state.getCertificationPage;
  },
  getFaqQues(state) {
    return state.getFaqQues;
  },
  getContactInfo(state) {
    return state.getContactInfo;
  },
  getStudentFeedbackPage(state) {
    return state.getStudentFeedbackPage;
  },
  getAllCertificates(state) {
    return state.getAllCertificates;
  },
  getStudentProfile(state) {
    return state.getStudentProfile;
  },
  getSubCategoryWithCourses(state) {
    return state.getSubCategoryWithCourses;
  },
  getCategoryWithCourses(state) {
    return state.getCategoryWithCourses;
  },
  getPartner(state) {
    return state.getPartner;
  },
  getCourseDetails(state) {
    return state.getCourseDetails;
  },
  getContactUs(state) {
    return state.getContactUs;
  },
  getCategoryData(state) {
    return state.getCategoryData;
  },
  getTrendyCategory(state) {
    return state.getTrendyCategory;
  },
  getMainCategoryExpand(state) {
    return state.getMainCategoryExpand;
  },
  getSubCategoryExpand(state) {
    return state.getSubCategoryExpand;
  },
  getTeacherCourses(state) {
    return state.getTeacherCourses;
  },
  getCourses(state) {
    return state.getCourses;
  },
  getCurrentLearning(state) {
    return state.getCurrentLearning;
  },
  getPopUpBanner(state) {
    return state.getPopUpBanner;
  },
  getHeaderBanner(state) {
    return state.getHeaderBanner;
  },
};

export const mutations = {
  getAllCourses(state, data) {
    return (state.getAllCourses = data);
  },
  getAllCategories(state, data) {
    return (state.getAllCategories = data);
  },
  countCart(state, data) {
    return (state.countCart = data);
  },
  getCarts(state, data) {
    return (state.getCarts = data);
  },
  discount_info(state, data) {
    return (state.discount_info = data);
  },
  getHomeData(state, data) {
    return (state.getHomeData = data);
  },
  getMainCategories(state, data) {
    return (state.getMainCategories = data);
  },
  getStudentFeedback(state, data) {
    return (state.getStudentFeedback = data);
  },
  getTrendyCourses(state, data) {
    return (state.getTrendyCourses = data);
  },
  getWishLists(state, data) {
    return (state.getWishLists = data);
  },
  getWishListCount(state, data) {
    return (state.getWishListCount = data);
  },
  getCertificationFind(state, data) {
    return (state.getCertificationFind = data);
  },
  getStudentCourseReport(state, data) {
    return (state.getStudentCourseReport = data);
  },
  getStudentPurchaseCourses(state, data) {
    return (state.getStudentPurchaseCourses = data);
  },
  getStudentCourseSingle(state, data) {
    return (state.getStudentCourseSingle = data);
  },
  updateLessonStatus(state, data) {
    state.getStudentCourseSingle.topics[data.topic_index].lessons[
      data.lesson_index
    ].status = data.status;
  },
  getAboutPage(state, data) {
    return (state.getAboutPage = data);
  },
  getCertificationPage(state, data) {
    return (state.getCertificationPage = data);
  },
  getFaqQues(state, data) {
    return (state.getFaqQues = data);
  },
  getContactInfo(state, data) {
    return (state.getContactInfo = data);
  },
  getStudentFeedbackPage(state, data) {
    return (state.getStudentFeedbackPage = data);
  },
  getAllCertificates(state, data) {
    return (state.getAllCertificates = data);
  },
  getStudentProfile(state, data) {
    return (state.getStudentProfile = data);
  },
  getSubCategoryWithCourses(state, data) {
    return (state.getSubCategoryWithCourses = data);
  },
  getCategoryWithCourses(state, data) {
    return (state.getCategoryWithCourses = data);
  },
  getPartner(state, data) {
    return (state.getPartner = data);
  },
  getCourseDetails(state, data) {
    return (state.getCourseDetails = data);
  },
  getContactUs(state, data) {
    return (state.getContactUs = data);
  },
  getCategoryData(state, data) {
    return (state.getCategoryData = data);
  },
  getTrendyCategory(state, data) {
    return (state.getTrendyCategory = data);
  },
  getMainCategoryExpand(state, data) {
    return (state.getMainCategoryExpand = data);
  },
  getSubCategoryExpand(state, data) {
    return (state.getSubCategoryExpand = data);
  },
  getTeacherCourses(state, data) {
    return (state.getTeacherCourses = data);
  },
  getCourses(state, data) {
    return (state.getCourses = data);
  },
  getCurrentLearning(state, data) {
    return (state.getCurrentLearning = data);
  },
  getPopUpBanner(state, data) {
    return (state.getPopUpBanner = data);
  },
  getHeaderBanner(state, data) {
    return (state.getHeaderBanner = data);
  },
};

export const actions = {
  async getAllCourses({ commit }, search) {
    const courses = await this.$axios.$post(
      "/frontend/courses?page=" + search.search.page,
      search.search
    );
    commit("getAllCourses", courses);
  },
  async getAllCategories({ commit }) {
    const categories = await this.$axios.$get("/frontend/all/categories");
    commit("getAllCategories", categories);
  },
  async addCart({ commit }, course_id) {
    try {
      const cart = await this.$axios.$post("/frontend/cart/" + course_id);
      this.$toast.success(cart.massage);
      commit("countCart", cart.count);
    } catch (error) {
      this.$toast.error(error.response.data.error);
    }
  },
  async countCart({ commit }) {
    const cart_count = await this.$axios.$get("/frontend/cart/count");
    commit("countCart", cart_count);
  },
  async getCarts({ commit }) {
    const carts = await this.$axios.$get("/frontend/cart");
    commit("getCarts", carts);
  },

  async deleteCart({ commit }, id) {
    try {
      const carts = await this.$axios.$delete("/frontend/cart/" + id);
      this.$toast.success(carts.massage);
      commit("countCart", carts.total_cart);
      commit("getCarts", carts.carts);
    } catch (error) {
      this.$toast.error(error.response.data.error);
    }
  },

  async applyCoupon({ commit }, form) {
    let t = this;
    this.$axios
      .$post("/frontend/apply/coupon", form)
      .then(function (res) {
        t.$toast.success(res.massage);
        commit("discount_info", res);
      })
      .catch((error) => {
        commit("discount_info", {});
        this.$toast.error(error.response.data.error);
      });
  },

  cancelCoupon({ commit }) {
    commit("discount_info", {});
  },

  async checkOut({ commit }, form) {
    let t = this;
    this.$axios
      .$post("/frontend/check/out", form)
      .then(function (res) {
        if (res.link) {
          if (res.link) {
            location.replace(res.link);
          } else {
            t.$toast.success(res.massage);
          }
        } else {
          location.replace("/dashboard");
        }
      })
      .catch((error) => {
        this.$toast.error(error.response.data.error);
      });
  },

  async getHomeData({ commit }) {
    const home_data = await this.$axios.$get("/frontend/home/content");
    commit("getHomeData", home_data);
  },

  async getMainCategories({ commit }) {
    const categories = await this.$axios.$get("/frontend/main/categories");
    commit("getMainCategories", categories);
  },
  async getStudentFeedback({ commit }, page) {
    const student_feedback = await this.$axios.$get(
      "/frontend/student/feedback?page=" + page
    );
    commit("getStudentFeedback", student_feedback);
  },
  async getTrendyCourses({ commit }, id) {
    const courses = await this.$axios.$post("/frontend/trendy/courses/" + id);
    commit("getTrendyCourses", courses);
  },
  async getWishLists({ commit }) {
    const wishLists = await this.$axios.$get("/frontend/wish-list");
    commit("getWishLists", wishLists);
  },
  async getWishListCount({ commit }) {
    const countWishLists = await this.$axios.$get("/frontend/wish-list/count");
    commit("getWishListCount", countWishLists);
  },

  async deleteWishList({ commit }, id) {
    try {
      const courses = await this.$axios.$delete("/frontend/wish-list/" + id);
      commit("getWishListCount", { count: courses.total_wishLists });
    } catch (error) {
      this.$toast.error(error.response.data.error);
    }
  },
  async addWishList({ commit }, course_id) {
    try {
      const course = await this.$axios.$post(
        "/frontend/wish-list/" + course_id
      );
      this.$toast.success(course.massage);
      commit("getWishListCount", { count: course.count });
    } catch (error) {
      this.$toast.error(error.response.data.error);
    }
  },
  async getCertificationFind({ commit }) {
    const certificationFindInfo = await this.$axios.$get(
      "/frontend/certification/find/page"
    );
    commit("getCertificationFind", certificationFindInfo);
  },

  async getStudentCourseReport({ commit }) {
    const report = await this.$axios.$get("/student/dashboard/report");
    commit("getStudentCourseReport", report);
  },
  async getStudentPurchaseCourses({ commit }) {
    const courses = await this.$axios.$get("/student/purchase/courses");
    commit("getStudentPurchaseCourses", courses.data);
  },
  async getAllCertificates({ commit }) {
    const certificates = await this.$axios.$get("/student/certificates");
    commit("getAllCertificates", certificates.data);
  },
  async getStudentProfile({ commit }) {
    const profile = await this.$axios.$get("/student/profile");
    commit("getStudentProfile", profile.data);
  },
  async getStudentCourseSingle({ commit }, slug) {
    const courses = await this.$axios.$post("/student/class/room/info/" + slug);
    commit("getStudentCourseSingle", courses);
  },
  async getAboutPage({ commit }, page) {
    const about_page = await this.$axios.$get("/frontend/about/page");
    commit("getAboutPage", about_page);
  },
  async getCertificationPage({ commit }) {
    const certificate_page = await this.$axios.$get(
      "/frontend/certification/page"
    );
    commit("getCertificationPage", certificate_page);
  },
  async getFaqQues({ commit }, page) {
    const questions = await this.$axios.$get(
      "/frontend/faq/question?page=" + page
    );
    commit("getFaqQues", questions);
  },
  async getContactInfo({ commit }) {
    const contact = await this.$axios.$get("/frontend/contact/us");
    commit("getContactInfo", contact);
  },
  async getStudentFeedbackPage({ commit }) {
    const studentfeedbackmain = await this.$axios.$get(
      "/frontend/student/feedback/page"
    );
    commit("getStudentFeedbackPage", studentfeedbackmain);
  },
  async getSubCategoryWithCourses({ commit }, id) {
    const courses = await this.$axios.$get(
      "/frontend/sub/category/courses/" + id
    );
    commit("getSubCategoryWithCourses", courses);
  },
  async getCategoryWithCourses({ commit }) {
    const courses = await this.$axios.$get(
      "/frontend/home/sub/category/courses"
    );
    commit("getCategoryWithCourses", courses);
  },
  async getMainCategoryExpand({ commit }) {
    const category = await this.$axios.$get("/frontend/main/category/expand");
    commit("getMainCategoryExpand", category);
  },
  async getSubCategoryExpand({ commit }, id) {
    const category = await this.$axios.$get(
      "/frontend/sub/category/expand/" + id
    );
    commit("getSubCategoryExpand", category);
  },
  async getPartner({ commit }) {
    const partners = await this.$axios.$get("/frontend/partner");
    commit("getPartner", partners);
  },
  async getCourseDetails({ commit }, id) {
    const courseDetails = await this.$axios.$get(
      "/frontend/course/details/" + id
    );
    commit("getCourseDetails", courseDetails);
  },
  async getContactUs({ commit }) {
    const contactUs = await this.$axios.$get("/frontend/contact/us");
    commit("getContactUs", contactUs);
  },

  async getCategoryData({ commit }, slug) {
    const category = await this.$axios.$get("/frontend/category/" + slug);
    commit("getCategoryData", category);
  },
  async getTrendyCategory({ commit }) {
    const categories = await this.$axios.$get("/frontend/trendy/categories");
    commit("getTrendyCategory", categories.data);
  },
  async getTeacherCourses({ commit }, id) {
    const teacher = await this.$axios.$get("/frontend/teacher/courses/" + id);
    commit("getTeacherCourses", teacher);
  },
  async getCourses({ commit }) {
    const Courses = await this.$axios.$get("/frontend/get/all/courses");
    commit("getCourses", Courses);
  },
  async getCurrentLearning({ commit }) {
    const Current = await this.$axios.$get("/student/current/learning");
    commit("getCurrentLearning", Current);
  },
  async getPopUpBanner({ commit }) {
    const PopUpBanner = await this.$axios.$get("/frontend/get/popUp/banner");
    commit("getPopUpBanner", PopUpBanner);
  },
  async getHeaderBanner({ commit }) {
    const HeaderBanner = await this.$axios.$get("/frontend/get/promotion/header/banner");
    commit("getHeaderBanner", HeaderBanner);
  },
};
