"use strict";var e,o,a=require("@csstools/css-tokenizer"),n=require("@csstools/color-helpers"),t=require("@csstools/css-parser-algorithms"),r=require("@csstools/css-calc");function colorData_to_XYZ_D50(e){switch(e.colorNotation){case exports.ColorNotation.HEX:case exports.ColorNotation.RGB:case exports.ColorNotation.sRGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.sRGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Linear_sRGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.lin_sRGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Display_P3:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.P3_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Rec2020:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.rec_2020_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.A98_RGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.a98_RGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.ProPhoto_RGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.ProPhoto_RGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.HSL:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.HSL_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.HWB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.HWB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Lab:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.Lab_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.OKLab:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.OKLab_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.LCH:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.LCH_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.OKLCH:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.OKLCH_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.XYZ_D50:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.XYZ_D50_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.XYZ_D65:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.xyz.XYZ_D65_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};default:throw new Error("Unsupported color notation")}}exports.ColorNotation=void 0,(e=exports.ColorNotation||(exports.ColorNotation={})).A98_RGB="a98-rgb",e.Display_P3="display-p3",e.HEX="hex",e.HSL="hsl",e.HWB="hwb",e.LCH="lch",e.Lab="lab",e.Linear_sRGB="srgb-linear",e.OKLCH="oklch",e.OKLab="oklab",e.ProPhoto_RGB="prophoto-rgb",e.RGB="rgb",e.sRGB="srgb",e.Rec2020="rec2020",e.XYZ_D50="xyz-d50",e.XYZ_D65="xyz-d65",exports.SyntaxFlag=void 0,(o=exports.SyntaxFlag||(exports.SyntaxFlag={})).ColorKeyword="color-keyword",o.HasAlpha="has-alpha",o.HasDimensionValues="has-dimension-values",o.HasNoneKeywords="has-none-keywords",o.HasNumberValues="has-number-values",o.HasPercentageAlpha="has-percentage-alpha",o.HasPercentageValues="has-percentage-values",o.HasVariableAlpha="has-variable-alpha",o.Hex="hex",o.LegacyHSL="legacy-hsl",o.LegacyRGB="legacy-rgb",o.NamedColor="named-color",o.RelativeColorSyntax="relative-color-syntax",o.ColorMix="color-mix";const s=new Set([exports.ColorNotation.A98_RGB,exports.ColorNotation.Display_P3,exports.ColorNotation.HEX,exports.ColorNotation.Linear_sRGB,exports.ColorNotation.ProPhoto_RGB,exports.ColorNotation.RGB,exports.ColorNotation.sRGB,exports.ColorNotation.Rec2020,exports.ColorNotation.XYZ_D50,exports.ColorNotation.XYZ_D65]);function colorDataTo(e,o){const a=colorData_to_XYZ_D50(e),t={...e};switch(o){case exports.ColorNotation.HEX:case exports.ColorNotation.RGB:t.colorNotation=exports.ColorNotation.RGB,t.channels=n.xyz.XYZ_D50_to_sRGB(a.channels);break;case exports.ColorNotation.sRGB:t.colorNotation=exports.ColorNotation.sRGB,t.channels=n.xyz.XYZ_D50_to_sRGB(a.channels);break;case exports.ColorNotation.Linear_sRGB:t.colorNotation=exports.ColorNotation.Linear_sRGB,t.channels=n.xyz.XYZ_D50_to_lin_sRGB(a.channels);break;case exports.ColorNotation.Display_P3:t.colorNotation=exports.ColorNotation.Display_P3,t.channels=n.xyz.XYZ_D50_to_P3(a.channels);break;case exports.ColorNotation.Rec2020:t.colorNotation=exports.ColorNotation.Rec2020,t.channels=n.xyz.XYZ_D50_to_rec_2020(a.channels);break;case exports.ColorNotation.ProPhoto_RGB:t.colorNotation=exports.ColorNotation.ProPhoto_RGB,t.channels=n.xyz.XYZ_D50_to_ProPhoto(a.channels);break;case exports.ColorNotation.A98_RGB:t.colorNotation=exports.ColorNotation.A98_RGB,t.channels=n.xyz.XYZ_D50_to_a98_RGB(a.channels);break;case exports.ColorNotation.HSL:t.colorNotation=exports.ColorNotation.HSL,t.channels=n.xyz.XYZ_D50_to_HSL(a.channels);break;case exports.ColorNotation.HWB:t.colorNotation=exports.ColorNotation.HWB,t.channels=n.xyz.XYZ_D50_to_HWB(a.channels);break;case exports.ColorNotation.Lab:t.colorNotation=exports.ColorNotation.Lab,t.channels=n.xyz.XYZ_D50_to_Lab(a.channels);break;case exports.ColorNotation.LCH:t.colorNotation=exports.ColorNotation.LCH,t.channels=n.xyz.XYZ_D50_to_LCH(a.channels);break;case exports.ColorNotation.OKLCH:t.colorNotation=exports.ColorNotation.OKLCH,t.channels=n.xyz.XYZ_D50_to_OKLCH(a.channels);break;case exports.ColorNotation.OKLab:t.colorNotation=exports.ColorNotation.OKLab,t.channels=n.xyz.XYZ_D50_to_OKLab(a.channels);break;case exports.ColorNotation.XYZ_D50:t.colorNotation=exports.ColorNotation.XYZ_D50,t.channels=n.xyz.XYZ_D50_to_XYZ_D50(a.channels);break;case exports.ColorNotation.XYZ_D65:t.colorNotation=exports.ColorNotation.XYZ_D65,t.channels=n.xyz.XYZ_D50_to_XYZ_D65(a.channels);break;default:throw new Error("Unsupported color notation")}if(o===e.colorNotation)t.channels=carryForwardMissingComponents(e.channels,[0,1,2],t.channels,[0,1,2]);else if(s.has(o)&&s.has(e.colorNotation))t.channels=carryForwardMissingComponents(e.channels,[0,1,2],t.channels,[0,1,2]);else switch(o){case exports.ColorNotation.HSL:switch(e.colorNotation){case exports.ColorNotation.HWB:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[0]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:t.channels=carryForwardMissingComponents(e.channels,[2],t.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:t.channels=carryForwardMissingComponents(e.channels,[0,1,2],t.channels,[2,1,0])}break;case exports.ColorNotation.HWB:switch(e.colorNotation){case exports.ColorNotation.HSL:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[2])}break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:switch(e.colorNotation){case exports.ColorNotation.HSL:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[2]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[0])}break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:switch(e.colorNotation){case exports.ColorNotation.HSL:t.channels=carryForwardMissingComponents(e.channels,[0,1,2],t.channels,[2,1,0]);break;case exports.ColorNotation.HWB:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[2]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:t.channels=carryForwardMissingComponents(e.channels,[0],t.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:t.channels=carryForwardMissingComponents(e.channels,[0,1,2],t.channels,[0,1,2])}}return t.channels=convertPowerlessComponentsToMissingComponents(t.channels,o),t}function convertPowerlessComponentsToMissingComponents(e,o){const a=[...e];switch(o){case exports.ColorNotation.HSL:(reducePrecision(a[2])<=0||reducePrecision(a[2])>=100)&&(a[0]=NaN,a[1]=NaN),a[1]<=0&&(a[0]=NaN);break;case exports.ColorNotation.HWB:Math.max(0,reducePrecision(a[1]))+Math.max(0,reducePrecision(a[2]))>=100&&(a[0]=NaN);break;case exports.ColorNotation.Lab:(reducePrecision(a[0])<=0||reducePrecision(a[0])>=100)&&(a[1]=NaN,a[2]=NaN);break;case exports.ColorNotation.LCH:reducePrecision(a[1])<=0&&(a[2]=NaN),(reducePrecision(a[0])<=0||reducePrecision(a[0])>=100)&&(a[1]=NaN,a[2]=NaN);break;case exports.ColorNotation.OKLab:(reducePrecision(a[0])<=0||reducePrecision(a[0])>=1)&&(a[1]=NaN,a[2]=NaN);break;case exports.ColorNotation.OKLCH:reducePrecision(a[1])<=0&&(a[2]=NaN),(reducePrecision(a[0])<=0||reducePrecision(a[0])>=1)&&(a[1]=NaN,a[2]=NaN)}return a}function carryForwardMissingComponents(e,o,a,n){const t=[...a];for(const a of o)Number.isNaN(e[o[a]])&&(t[n[a]]=NaN);return t}function fillInMissingComponents(e,o){const a=[...e];for(let n=0;n<e.length;n++)Number.isNaN(e[n])&&(a[n]=o[n]);return a}function normalizeRelativeColorDataChannels(e){const o=new Map;switch(e.colorNotation){case exports.ColorNotation.RGB:case exports.ColorNotation.HEX:o.set("r",dummyNumberToken(255*e.channels[0])),o.set("g",dummyNumberToken(255*e.channels[1])),o.set("b",dummyNumberToken(255*e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.HSL:o.set("h",dummyAngleToken(e.channels[0])),o.set("s",dummyPercentageToken(e.channels[1])),o.set("l",dummyPercentageToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.HWB:o.set("h",dummyAngleToken(e.channels[0])),o.set("w",dummyPercentageToken(e.channels[1])),o.set("b",dummyPercentageToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:o.set("l",dummyNumberToken(e.channels[0])),o.set("a",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:o.set("l",dummyNumberToken(e.channels[0])),o.set("c",dummyNumberToken(e.channels[1])),o.set("h",dummyAngleToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.sRGB:case exports.ColorNotation.A98_RGB:case exports.ColorNotation.Display_P3:case exports.ColorNotation.Rec2020:case exports.ColorNotation.Linear_sRGB:case exports.ColorNotation.ProPhoto_RGB:o.set("r",dummyNumberToken(e.channels[0])),o.set("g",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.XYZ_D50:case exports.ColorNotation.XYZ_D65:o.set("x",dummyNumberToken(e.channels[0])),o.set("y",dummyNumberToken(e.channels[1])),o.set("z",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha))}return o}function noneToZeroInRelativeColorDataChannels(e){const o=new Map;for(const[a,n]of e)Number.isNaN(n[4].value)?o.set(a,dummyNumberToken(0)):o.set(a,n);return o}function dummyNumberToken(e){return[a.TokenType.Number,e.toString(),-1,-1,{value:e,type:a.NumberType.Number}]}function dummyPercentageToken(e){return[a.TokenType.Percentage,e.toString()+"%",-1,-1,{value:e}]}function dummyAngleToken(e){return[a.TokenType.Dimension,e.toString()+"deg",-1,-1,{value:e,type:a.NumberType.Number,unit:"deg"}]}function reducePrecision(e,o=7){const a=Math.pow(10,o);return Math.round(e*a)/a}function normalize(e,o,a,n){return Math.min(Math.max(e/o,a),n)}const l=/[A-Z]/g;function toLowerCaseAZ(e){return e.replace(l,(e=>String.fromCharCode(e.charCodeAt(0)+32)))}function normalize_Color_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,-1/0,1/0);3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:r[4].value,type:a.NumberType.Number}])}}else{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,100,-1/0,1/0);3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}const i=new Set(["srgb","srgb-linear","display-p3","a98-rgb","prophoto-rgb","rec2020","xyz","xyz-d50","xyz-d65"]);function color$1(e,o){const n=[],s=[],l=[],u=[];let c,p,N=!1,m=!1;const h={colorNotation:exports.ColorNotation.sRGB,channels:[0,0,0],alpha:1,syntaxFlags:new Set([])};let y=n;for(let x=0;x<e.value.length;x++){let C=e.value[x];if(t.isWhitespaceNode(C)||t.isCommentNode(C))for(;t.isWhitespaceNode(e.value[x+1])||t.isCommentNode(e.value[x+1]);)x++;else if(y===n&&n.length&&(y=s),y===s&&s.length&&(y=l),t.isTokenNode(C)&&C.value[0]===a.TokenType.Delim&&"/"===C.value[4].value){if(y===u)return!1;y=u}else{if(t.isFunctionNode(C)){if(y===u&&"var"===toLowerCaseAZ(C.getName())){h.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),y.push(C);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(C.getName())))return!1;const[[e]]=r.calcFromComponentValues([[C]],{toCanonicalUnits:!0,precision:100,globals:p});if(!e||!t.isTokenNode(e)||(e.value[0]===a.TokenType.Percentage||e.value[0]===a.TokenType.Number||e.value[0]===a.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;C=e}if(y===n&&0===n.length&&t.isTokenNode(C)&&C.value[0]===a.TokenType.Ident&&i.has(toLowerCaseAZ(C.value[4].value))){if(N)return!1;N=toLowerCaseAZ(C.value[4].value),h.colorNotation=colorSpaceNameToColorNotation(N),m&&(m.colorNotation!==h.colorNotation&&(m=colorDataTo(m,h.colorNotation)),c=normalizeRelativeColorDataChannels(m),p=noneToZeroInRelativeColorDataChannels(c))}else if(y===n&&0===n.length&&t.isTokenNode(C)&&C.value[0]===a.TokenType.Ident&&"from"===toLowerCaseAZ(C.value[4].value)){if(m)return!1;if(N)return!1;for(;t.isWhitespaceNode(e.value[x+1])||t.isCommentNode(e.value[x+1]);)x++;if(x++,C=e.value[x],m=o(C),!1===m)return!1;h.syntaxFlags.add(exports.SyntaxFlag.RelativeColorSyntax)}else{if(!t.isTokenNode(C))return!1;if(C.value[0]===a.TokenType.Ident&&c&&c.has(toLowerCaseAZ(C.value[4].value))){y.push(new t.TokenNode(c.get(toLowerCaseAZ(C.value[4].value))));continue}y.push(C)}}}if(!N)return!1;if(1!==y.length)return!1;if(1!==n.length||1!==s.length||1!==l.length)return!1;if(!t.isTokenNode(n[0])||!t.isTokenNode(s[0])||!t.isTokenNode(l[0]))return!1;if(c&&!c.has("alpha"))return!1;const x=[n[0].value,s[0].value,l[0].value];1===u.length?(h.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(u[0])?x.push(u[0].value):h.alpha=u[0]):c&&c.has("alpha")&&x.push(c.get("alpha"));const C=normalize_Color_ChannelValues(x,h);return!1!==C&&(h.channels=[C[0][4].value,C[1][4].value,C[2][4].value],4===C.length&&(h.alpha=C[3][4].value),h)}function colorSpaceNameToColorNotation(e){switch(e){case"srgb":return exports.ColorNotation.sRGB;case"srgb-linear":return exports.ColorNotation.Linear_sRGB;case"display-p3":return exports.ColorNotation.Display_P3;case"a98-rgb":return exports.ColorNotation.A98_RGB;case"prophoto-rgb":return exports.ColorNotation.ProPhoto_RGB;case"rec2020":return exports.ColorNotation.Rec2020;case"xyz":case"xyz-d65":return exports.ColorNotation.XYZ_D65;case"xyz-d50":return exports.ColorNotation.XYZ_D50;default:throw new Error("Unknown color space name: "+e)}}const u=new Set(["srgb","srgb-linear","lab","oklab","xyz","xyz-d50","xyz-d65"]),c=new Set(["hsl","hwb","lch","oklch"]),p=new Set(["shorter","longer","increasing","decreasing"]);function colorMix(e,o){let n=null,r=null,s=null,l=!1;for(let i=0;i<e.value.length;i++){const N=e.value[i];if(!t.isWhitespaceNode(N)&&!t.isCommentNode(N)){if(t.isTokenNode(N)&&N.value[0]===a.TokenType.Ident){if(!n&&"in"===toLowerCaseAZ(N.value[4].value)){n=N;continue}if(n&&!r){r=toLowerCaseAZ(N.value[4].value);continue}if(n&&r&&!s&&c.has(r)){s=toLowerCaseAZ(N.value[4].value);continue}if(n&&r&&s&&!l&&"hue"===toLowerCaseAZ(N.value[4].value)){l=!0;continue}return!1}return!(!t.isTokenNode(N)||N.value[0]!==a.TokenType.Comma)&&(!!r&&(s||l?!!(r&&s&&l&&c.has(r)&&p.has(s))&&colorMixPolar(r,s,colorMixComponents(e.value.slice(i+1),o)):u.has(r)?colorMixRectangular(r,colorMixComponents(e.value.slice(i+1),o)):!!c.has(r)&&colorMixPolar(r,"shorter",colorMixComponents(e.value.slice(i+1),o))))}}return!1}function colorMixComponents(e,o){const n=[];let s=1,l=!1,i=!1;for(let s=0;s<e.length;s++){let u=e[s];if(!t.isWhitespaceNode(u)&&!t.isCommentNode(u)){if(!t.isTokenNode(u)||u.value[0]!==a.TokenType.Comma){if(!l){const e=o(u);if(e){l=e;continue}}if(!i){if(t.isFunctionNode(u)&&r.mathFunctionNames.has(toLowerCaseAZ(u.getName()))&&([[u]]=r.calcFromComponentValues([[u]],{toCanonicalUnits:!0,precision:100}),!u||!t.isTokenNode(u)||(u.value[0]===a.TokenType.Percentage||u.value[0]===a.TokenType.Number||u.value[0]===a.TokenType.Dimension)&&Number.isNaN(u.value[4].value)))return!1;if(t.isTokenNode(u)&&u.value[0]===a.TokenType.Percentage&&u.value[4].value>=0){i=u.value[4].value;continue}}return!1}if(!l)return!1;n.push({color:l,percentage:i}),l=!1,i=!1}}if(l&&n.push({color:l,percentage:i}),2!==n.length)return!1;let u=n[0].percentage,c=n[1].percentage;return(!1===u||!(u<0||u>100))&&((!1===c||!(c<0||c>100))&&(!1===u&&!1===c?(u=50,c=50):!1!==u&&!1===c?c=100-u:!1===u&&!1!==c&&(u=100-c),(0!==u||0!==c)&&(!1!==u&&!1!==c&&(u+c>100&&(u=u/(u+c)*100,c=c/(u+c)*100),u+c<100&&(s=(u+c)/100,u=u/(u+c)*100,c=c/(u+c)*100),{a:{color:n[0].color,percentage:u},b:{color:n[1].color,percentage:c},alphaMultiplier:s}))))}function colorMixRectangular(e,o){if(!o)return!1;const a=o.a.color,n=o.b.color,t=o.a.percentage/100;let r=a.channels,s=n.channels,l=exports.ColorNotation.RGB,i=a.alpha;if("number"!=typeof i)return!1;let u=n.alpha;if("number"!=typeof u)return!1;switch(i=Number.isNaN(i)?u:i,u=Number.isNaN(u)?i:u,e){case"srgb":l=exports.ColorNotation.RGB,a.colorNotation!==exports.ColorNotation.RGB&&a.colorNotation!==exports.ColorNotation.sRGB&&a.colorNotation!==exports.ColorNotation.HEX&&(r=colorDataTo(a,exports.ColorNotation.RGB).channels),n.colorNotation!==exports.ColorNotation.RGB&&n.colorNotation!==exports.ColorNotation.sRGB&&n.colorNotation!==exports.ColorNotation.HEX&&(s=colorDataTo(n,exports.ColorNotation.RGB).channels);break;case"srgb-linear":l=exports.ColorNotation.Linear_sRGB,a.colorNotation!==exports.ColorNotation.Linear_sRGB&&(r=colorDataTo(a,exports.ColorNotation.Linear_sRGB).channels),n.colorNotation!==exports.ColorNotation.Linear_sRGB&&(s=colorDataTo(n,exports.ColorNotation.Linear_sRGB).channels);break;case"lab":l=exports.ColorNotation.Lab,a.colorNotation!==exports.ColorNotation.Lab&&(r=colorDataTo(a,exports.ColorNotation.Lab).channels),n.colorNotation!==exports.ColorNotation.Lab&&(s=colorDataTo(n,exports.ColorNotation.Lab).channels);break;case"oklab":l=exports.ColorNotation.OKLab,a.colorNotation!==exports.ColorNotation.OKLab&&(r=colorDataTo(a,exports.ColorNotation.OKLab).channels),n.colorNotation!==exports.ColorNotation.OKLab&&(s=colorDataTo(n,exports.ColorNotation.OKLab).channels);break;case"xyz-d50":l=exports.ColorNotation.XYZ_D50,a.colorNotation!==exports.ColorNotation.XYZ_D50&&(r=colorDataTo(a,exports.ColorNotation.XYZ_D50).channels),n.colorNotation!==exports.ColorNotation.XYZ_D50&&(s=colorDataTo(n,exports.ColorNotation.XYZ_D50).channels);break;case"xyz":case"xyz-d65":l=exports.ColorNotation.XYZ_D65,a.colorNotation!==exports.ColorNotation.XYZ_D65&&(r=colorDataTo(a,exports.ColorNotation.XYZ_D65).channels),n.colorNotation!==exports.ColorNotation.XYZ_D65&&(s=colorDataTo(n,exports.ColorNotation.XYZ_D65).channels)}r=fillInMissingComponents(r,s),s=fillInMissingComponents(s,r),r[0]=premultiply(r[0],i),r[1]=premultiply(r[1],i),r[2]=premultiply(r[2],i),s[0]=premultiply(s[0],u),s[1]=premultiply(s[1],u),s[2]=premultiply(s[2],u);const c=interpolate(i,u,t);return{colorNotation:l,channels:[un_premultiply(interpolate(r[0],s[0],t),c),un_premultiply(interpolate(r[1],s[1],t),c),un_premultiply(interpolate(r[2],s[2],t),c)],alpha:c*o.alphaMultiplier,syntaxFlags:new Set([exports.SyntaxFlag.ColorMix])}}function colorMixPolar(e,o,a){if(!a)return!1;const n=a.a.color,t=a.b.color,r=a.a.percentage/100;let s=n.channels,l=t.channels,i=0,u=0,c=0,p=0,N=0,m=0,h=exports.ColorNotation.RGB,y=n.alpha;if("number"!=typeof y)return!1;let x=t.alpha;if("number"!=typeof x)return!1;switch(y=Number.isNaN(y)?x:y,x=Number.isNaN(x)?y:x,e){case"hsl":h=exports.ColorNotation.HSL,n.colorNotation!==exports.ColorNotation.HSL&&(s=colorDataTo(n,exports.ColorNotation.HSL).channels),t.colorNotation!==exports.ColorNotation.HSL&&(l=colorDataTo(t,exports.ColorNotation.HSL).channels);break;case"hwb":h=exports.ColorNotation.HWB,n.colorNotation!==exports.ColorNotation.HWB&&(s=colorDataTo(n,exports.ColorNotation.HWB).channels),t.colorNotation!==exports.ColorNotation.HWB&&(l=colorDataTo(t,exports.ColorNotation.HWB).channels);break;case"lch":h=exports.ColorNotation.LCH,n.colorNotation!==exports.ColorNotation.LCH&&(s=colorDataTo(n,exports.ColorNotation.LCH).channels),t.colorNotation!==exports.ColorNotation.LCH&&(l=colorDataTo(t,exports.ColorNotation.LCH).channels);break;case"oklch":h=exports.ColorNotation.OKLCH,n.colorNotation!==exports.ColorNotation.OKLCH&&(s=colorDataTo(n,exports.ColorNotation.OKLCH).channels),t.colorNotation!==exports.ColorNotation.OKLCH&&(l=colorDataTo(t,exports.ColorNotation.OKLCH).channels)}switch(s=fillInMissingComponents(s,l),l=fillInMissingComponents(l,s),e){case"hsl":case"hwb":i=s[0],u=l[0],c=s[1],p=l[1],N=s[2],m=l[2];break;case"lch":case"oklch":c=s[0],p=l[0],N=s[1],m=l[1],i=s[2],u=l[2]}const C=u-i;switch(o){case"shorter":C>180?i+=360:C<-180&&(u+=360);break;case"longer":-180<C&&C<180&&(C>0?i+=360:u+=360);break;case"increasing":C<0&&(u+=360);break;case"decreasing":C>0&&(i+=360);break;default:throw new Error("Unknown hue interpolation method")}c=premultiply(c,y),N=premultiply(N,y),p=premultiply(p,x),m=premultiply(m,x);let T=[0,0,0];const b=interpolate(y,x,r);switch(e){case"hsl":case"hwb":T=[interpolate(i,u,r),un_premultiply(interpolate(c,p,r),b),un_premultiply(interpolate(N,m,r),b)];break;case"lch":case"oklch":T=[un_premultiply(interpolate(c,p,r),b),un_premultiply(interpolate(N,m,r),b),interpolate(i,u,r)]}return{colorNotation:h,channels:T,alpha:b*a.alphaMultiplier,syntaxFlags:new Set([exports.SyntaxFlag.ColorMix])}}function interpolate(e,o,a){return Number.isNaN(e)?o:Number.isNaN(o)?e:e*a+o*(1-a)}function premultiply(e,o){return Number.isNaN(o)?e:Number.isNaN(e)?NaN:e*o}function un_premultiply(e,o){return 0===o||Number.isNaN(o)?e:Number.isNaN(e)?NaN:e/o}function hex(e){const o=toLowerCaseAZ(e[4].value);if(o.match(/[^a-f0-9]/))return!1;const a={colorNotation:exports.ColorNotation.HEX,channels:[0,0,0],alpha:1,syntaxFlags:new Set([exports.SyntaxFlag.Hex])},n=o.length;if(3===n){const e=o[0],n=o[1],t=o[2];return a.channels=[parseInt(e+e,16)/255,parseInt(n+n,16)/255,parseInt(t+t,16)/255],a}if(6===n){const e=o[0]+o[1],n=o[2]+o[3],t=o[4]+o[5];return a.channels=[parseInt(e,16)/255,parseInt(n,16)/255,parseInt(t,16)/255],a}if(4===n){const e=o[0],n=o[1],t=o[2],r=o[3];return a.channels=[parseInt(e+e,16)/255,parseInt(n+n,16)/255,parseInt(t+t,16)/255],a.alpha=parseInt(r+r,16)/255,a.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),a}if(8===n){const e=o[0]+o[1],n=o[2]+o[3],t=o[4]+o[5],r=o[6]+o[7];return a.channels=[parseInt(e,16)/255,parseInt(n,16)/255,parseInt(t,16)/255],a.alpha=parseInt(r,16)/255,a.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),a}return!1}function normalizeHue(e){if(e[0]===a.TokenType.Number)return e[4].value=e[4].value%360,e[1]=e[4].value.toString(),e;if(e[0]===a.TokenType.Dimension){let o=e[4].value;switch(toLowerCaseAZ(e[4].unit)){case"deg":break;case"rad":o=180*e[4].value/Math.PI;break;case"grad":o=.9*e[4].value;break;case"turn":o=360*e[4].value;break;default:return!1}return o%=360,[a.TokenType.Number,o.toString(),e[2],e[3],{value:o,type:a.NumberType.Number}]}return!1}function normalize_legacy_HSL_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(0!==t)if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,0,100);3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}}else{3===t?o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,1,0,100);3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else{const e=normalizeHue(r);if(!1===e)return!1;r[0]===a.TokenType.Dimension&&o.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),n.push(e)}}return!o.syntaxFlags.has(exports.SyntaxFlag.HasNumberValues)&&n}function normalize_modern_HSL_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(0!==t)if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,0,100);3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}}else{3===t?o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,1,0,100);3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else{const e=normalizeHue(r);if(!1===e)return!1;r[0]===a.TokenType.Dimension&&o.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),n.push(e)}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function threeChannelLegacySyntax(e,o,n,s){const l=[],i=[],u=[],c=[],p={colorNotation:n,channels:[0,0,0],alpha:1,syntaxFlags:new Set(s)};let N=l;for(let o=0;o<e.value.length;o++){let n=e.value[o];if(!t.isWhitespaceNode(n)&&!t.isCommentNode(n)){if(t.isTokenNode(n)&&n.value[0]===a.TokenType.Comma){if(N===l){N=i;continue}if(N===i){N=u;continue}if(N===u){N=c;continue}if(N===c)return!1}if(t.isFunctionNode(n)){if(N===c&&"var"===toLowerCaseAZ(n.getName())){p.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),N.push(n);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(n.getName())))return!1;const[[e]]=r.calcFromComponentValues([[n]],{toCanonicalUnits:!0,precision:100});if(!e||!t.isTokenNode(e)||(e.value[0]===a.TokenType.Percentage||e.value[0]===a.TokenType.Number||e.value[0]===a.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;n=e}if(!t.isTokenNode(n))return!1;N.push(n)}}if(1!==N.length)return!1;if(1!==l.length||1!==i.length||1!==u.length)return!1;if(!t.isTokenNode(l[0])||!t.isTokenNode(i[0])||!t.isTokenNode(u[0]))return!1;const m=[l[0].value,i[0].value,u[0].value];1===c.length&&(p.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(c[0])?m.push(c[0].value):p.alpha=c[0]);const h=o(m,p);return!1!==h&&(p.channels=[h[0][4].value,h[1][4].value,h[2][4].value],4===h.length&&(p.alpha=h[3][4].value),p)}function XYZ_D50_to_sRGB_Gamut(e){const o=n.xyz.XYZ_D50_to_sRGB(e);if(n.utils.inGamut(o))return n.utils.clip(o);let a=e.slice();return a=n.conversions.D50_to_D65(a),a=n.conversions.XYZ_to_OKLab(a),a=n.conversions.OKLab_to_OKLCH(a),a[0]<1e-6&&(a=[0,0,0]),a[0]>.999999&&(a=[1,0,0]),n.calculations.mapGamut(a,(e=>(e=n.conversions.OKLCH_to_OKLab(e),e=n.conversions.OKLab_to_XYZ(e),e=n.conversions.XYZ_to_lin_sRGB(e),n.conversions.gam_sRGB(e))),(e=>(e=n.conversions.lin_sRGB(e),e=n.conversions.lin_sRGB_to_XYZ(e),e=n.conversions.XYZ_to_OKLab(e),n.conversions.OKLab_to_OKLCH(e))))}function threeChannelSpaceSeparated(e,o,s,l,i){const u=toLowerCaseAZ(e.getName()),c=[],p=[],N=[],m=[];let h,y,x=!1;const C={colorNotation:s,channels:[0,0,0],alpha:1,syntaxFlags:new Set(l)};let T=c;for(let o=0;o<e.value.length;o++){let l=e.value[o];if(t.isWhitespaceNode(l)||t.isCommentNode(l))for(;t.isWhitespaceNode(e.value[o+1])||t.isCommentNode(e.value[o+1]);)o++;else if(T===c&&c.length&&(T=p),T===p&&p.length&&(T=N),t.isTokenNode(l)&&l.value[0]===a.TokenType.Delim&&"/"===l.value[4].value){if(T===m)return!1;T=m}else{if(t.isFunctionNode(l)){if(T===m&&"var"===toLowerCaseAZ(l.getName())){C.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),T.push(l);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(l.getName())))return!1;const[[e]]=r.calcFromComponentValues([[l]],{toCanonicalUnits:!0,precision:100,globals:y});if(!e||!t.isTokenNode(e)||(e.value[0]===a.TokenType.Percentage||e.value[0]===a.TokenType.Number||e.value[0]===a.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;l=e}if(T===c&&0===c.length&&t.isTokenNode(l)&&l.value[0]===a.TokenType.Ident&&"from"===toLowerCaseAZ(l.value[4].value)&&"hsla"!==u&&"rgba"!==u){if(x)return!1;for(;t.isWhitespaceNode(e.value[o+1])||t.isCommentNode(e.value[o+1]);)o++;if(o++,l=e.value[o],x=i(l),!1===x)return!1;C.syntaxFlags.add(exports.SyntaxFlag.RelativeColorSyntax),x.colorNotation!==s&&(x=colorDataTo(x,s)),s===exports.ColorNotation.HEX||s===exports.ColorNotation.RGB?x.channels=XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(x).channels):s===exports.ColorNotation.HSL?x.channels=n.conversions.sRGB_to_HSL(XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(x).channels)):s===exports.ColorNotation.HWB&&(x.channels=n.conversions.sRGB_to_HWB(XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(x).channels))),h=normalizeRelativeColorDataChannels(x),y=noneToZeroInRelativeColorDataChannels(h)}else{if(!t.isTokenNode(l))return!1;if(l.value[0]===a.TokenType.Ident&&h&&h.has(toLowerCaseAZ(l.value[4].value))){T.push(new t.TokenNode(h.get(toLowerCaseAZ(l.value[4].value))));continue}T.push(l)}}}if(1!==T.length)return!1;if(1!==c.length||1!==p.length||1!==N.length)return!1;if(!t.isTokenNode(c[0])||!t.isTokenNode(p[0])||!t.isTokenNode(N[0]))return!1;if(h&&!h.has("alpha"))return!1;const b=[c[0].value,p[0].value,N[0].value];1===m.length?(C.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(m[0])?b.push(m[0].value):C.alpha=m[0]):h&&h.has("alpha")&&b.push(h.get("alpha"));const g=o(b,C);return!1!==g&&(C.channels=[g[0][4].value,g[1][4].value,g[2][4].value],4===g.length&&(C.alpha=g[3][4].value),C)}function hsl(e,o){if(e.value.some((e=>t.isTokenNode(e)&&e.value[0]===a.TokenType.Comma))){const o=hslCommaSeparated(e);if(!1!==o)return o}{const a=hslSpaceSeparated(e,o);if(!1!==a)return a}return!1}function hslCommaSeparated(e){return threeChannelLegacySyntax(e,normalize_legacy_HSL_ChannelValues,exports.ColorNotation.HSL,[exports.SyntaxFlag.LegacyHSL])}function hslSpaceSeparated(e,o){return threeChannelSpaceSeparated(e,normalize_modern_HSL_ChannelValues,exports.ColorNotation.HSL,[],o)}function normalize_HWB_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(0!==t)if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{if(3!==t)return!1;const e=normalize(r[4].value,1,0,1);n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}}else{3===t?o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,1,0,100);3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else{const e=normalizeHue(r);if(!1===e)return!1;r[0]===a.TokenType.Dimension&&o.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),n.push(e)}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function normalize_Lab_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,0,100);1===t||2===t?e=normalize(r[4].value,1,-1/0,1/0):3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:r[4].value,type:a.NumberType.Number}])}}else{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,1,0,100);1===t||2===t?e=normalize(r[4].value,.8,-1/0,1/0):3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function lab(e,o){return threeChannelSpaceSeparated(e,normalize_Lab_ChannelValues,exports.ColorNotation.Lab,[],o)}function normalize_LCH_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(2!==t)if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,0,100);1===t?e=normalize(r[4].value,1,0,1/0):3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:r[4].value,type:a.NumberType.Number}])}}else{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,1,0,100);1===t?e=normalize(r[4].value,100/150,0,1/0):3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else{const e=normalizeHue(r);if(!1===e)return!1;r[0]===a.TokenType.Dimension&&o.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),n.push(e)}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function lch(e,o){return threeChannelSpaceSeparated(e,normalize_LCH_ChannelValues,exports.ColorNotation.LCH,[],o)}const N=new Map;for(const[e,o]of Object.entries(n.namedColors))N.set(e,o);function namedColor(e){const o=N.get(toLowerCaseAZ(e));return!!o&&{colorNotation:exports.ColorNotation.RGB,channels:[o[0]/255,o[1]/255,o[2]/255],alpha:1,syntaxFlags:new Set([exports.SyntaxFlag.ColorKeyword,exports.SyntaxFlag.NamedColor])}}function normalize_OKLab_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,0,1);1===t||2===t?e=normalize(r[4].value,1,-1/0,1/0):3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:r[4].value,type:a.NumberType.Number}])}}else{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,100,0,1);1===t||2===t?e=normalize(r[4].value,250,-1/0,1/0):3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function oklab(e,o){return threeChannelSpaceSeparated(e,normalize_OKLab_ChannelValues,exports.ColorNotation.OKLab,[],o)}function normalize_OKLCH_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(2!==t)if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,1,0,1);1===t?e=normalize(r[4].value,1,0,1/0):3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:r[4].value,type:a.NumberType.Number}])}}else{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let e=normalize(r[4].value,100,0,1);1===t?e=normalize(r[4].value,250,0,1/0):3===t&&(e=normalize(r[4].value,100,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else{const e=normalizeHue(r);if(!1===e)return!1;r[0]===a.TokenType.Dimension&&o.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),n.push(e)}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function oklch(e,o){return threeChannelSpaceSeparated(e,normalize_OKLCH_ChannelValues,exports.ColorNotation.OKLCH,[],o)}function normalize_legacy_sRGB_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,255,0,1);3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}}else{3===t?o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);const e=normalize(r[4].value,100,0,1);n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}}return(!o.syntaxFlags.has(exports.SyntaxFlag.HasNumberValues)||!o.syntaxFlags.has(exports.SyntaxFlag.HasPercentageValues))&&n}function normalize_modern_sRGB_ChannelValues(e,o){const n=[];for(let t=0;t<e.length;t++){const r=e[t];if(r[0]!==a.TokenType.Ident||"none"!==toLowerCaseAZ(r[4].value))if(r[0]!==a.TokenType.Percentage){if(r[0]!==a.TokenType.Number)return!1;{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let e=normalize(r[4].value,255,0,1);3===t&&(e=normalize(r[4].value,1,0,1)),n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}}else{3!==t&&o.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);const e=normalize(r[4].value,100,0,1);n.push([a.TokenType.Number,e.toString(),r[2],r[3],{value:e,type:a.NumberType.Number}])}else o.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),n.push([a.TokenType.Number,"none",r[2],r[3],{value:NaN,type:a.NumberType.Number}])}return n}function rgb(e,o){if(e.value.some((e=>t.isTokenNode(e)&&e.value[0]===a.TokenType.Comma))){const o=rgbCommaSeparated(e);if(!1!==o)return o}else{const a=rgbSpaceSeparated(e,o);if(!1!==a)return a}return!1}function rgbCommaSeparated(e){return threeChannelLegacySyntax(e,normalize_legacy_sRGB_ChannelValues,exports.ColorNotation.RGB,[exports.SyntaxFlag.LegacyRGB])}function rgbSpaceSeparated(e,o){return threeChannelSpaceSeparated(e,normalize_modern_sRGB_ChannelValues,exports.ColorNotation.RGB,[],o)}function toPrecision(e,o=7){e=+e,o=+o;const a=(Math.floor(e)+"").length;if(o>a)return+e.toFixed(o-a);{const n=10**(a-o);return Math.round(e/n)*n}}function XYZ_D50_to_P3_Gamut(e){const o=n.xyz.XYZ_D50_to_P3(e);if(n.utils.inGamut(o))return n.utils.clip(o);let a=e.slice();return a=n.conversions.D50_to_D65(a),a=n.conversions.XYZ_to_OKLab(a),a=n.conversions.OKLab_to_OKLCH(a),a[0]<1e-6&&(a=[0,0,0]),a[0]>.999999&&(a=[1,0,0]),n.calculations.mapGamut(a,(e=>(e=n.conversions.OKLCH_to_OKLab(e),e=n.conversions.OKLab_to_XYZ(e),e=n.conversions.XYZ_to_lin_P3(e),n.conversions.gam_P3(e))),(e=>(e=n.conversions.lin_P3(e),e=n.conversions.lin_P3_to_XYZ(e),e=n.conversions.XYZ_to_OKLab(e),n.conversions.OKLab_to_OKLCH(e))))}exports.color=function color(e){if(t.isFunctionNode(e)){switch(toLowerCaseAZ(e.getName())){case"rgb":case"rgba":return rgb(e,color);case"hsl":case"hsla":return hsl(e,color);case"hwb":return o=color,threeChannelSpaceSeparated(e,normalize_HWB_ChannelValues,exports.ColorNotation.HWB,[],o);case"lab":return lab(e,color);case"lch":return lch(e,color);case"oklab":return oklab(e,color);case"oklch":return oklch(e,color);case"color":return color$1(e,color);case"color-mix":return colorMix(e,color)}}var o;if(t.isTokenNode(e)){if(e.value[0]===a.TokenType.Hash)return hex(e.value);if(e.value[0]===a.TokenType.Ident){const o=namedColor(e.value[4].value);return!1!==o?o:"transparent"===toLowerCaseAZ(e.value[4].value)&&{colorNotation:exports.ColorNotation.RGB,channels:[0,0,0],alpha:0,syntaxFlags:new Set([exports.SyntaxFlag.ColorKeyword])}}}return!1},exports.colorDataFitsRGB_Gamut=function colorDataFitsRGB_Gamut(e){return!colorDataTo(e,exports.ColorNotation.RGB).channels.find((e=>e<-1e-5||e>1.00001))},exports.colorDataTo=colorDataTo,exports.serializeP3=function serializeP3(e,o=!0){e.channels=convertPowerlessComponentsToMissingComponents(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));e.colorNotation!==exports.ColorNotation.Display_P3&&(r=o?XYZ_D50_to_P3_Gamut(colorData_to_XYZ_D50(e).channels):n.xyz.XYZ_D50_to_P3(colorData_to_XYZ_D50(e).channels));const s=toPrecision(r[0],6),l=toPrecision(r[1],6),i=toPrecision(r[2],6),u=[a.TokenType.Function,"color(",-1,-1,{value:"color"}],c=[a.TokenType.CloseParen,")",-1,-1,void 0],p=[a.TokenType.Whitespace," ",-1,-1,void 0],N=[new t.TokenNode([a.TokenType.Ident,"display-p3",-1,-1,{value:"display-p3"}]),new t.TokenNode(p),new t.TokenNode([a.TokenType.Number,s.toString(),-1,-1,{value:r[0],type:a.NumberType.Number}]),new t.TokenNode(p),new t.TokenNode([a.TokenType.Number,l.toString(),-1,-1,{value:r[1],type:a.NumberType.Number}]),new t.TokenNode(p),new t.TokenNode([a.TokenType.Number,i.toString(),-1,-1,{value:r[2],type:a.NumberType.Number}])];if("number"==typeof e.alpha){const o=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(o,4)?new t.FunctionNode(u,c,N):new t.FunctionNode(u,c,[...N,new t.TokenNode(p),new t.TokenNode([a.TokenType.Delim,"/",-1,-1,{value:"/"}]),new t.TokenNode(p),new t.TokenNode([a.TokenType.Number,toPrecision(o,4).toString(),-1,-1,{value:e.alpha,type:a.NumberType.Integer}])])}return new t.FunctionNode(u,c,[...N,new t.TokenNode(p),new t.TokenNode([a.TokenType.Delim,"/",-1,-1,{value:"/"}]),new t.TokenNode(p),e.alpha])},exports.serializeRGB=function serializeRGB(e,o=!0){e.channels=convertPowerlessComponentsToMissingComponents(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));e.colorNotation===exports.ColorNotation.HWB?r=n.conversions.HWB_to_sRGB(r):e.colorNotation===exports.ColorNotation.HSL?r=n.conversions.HSL_to_sRGB(r):e.colorNotation!==exports.ColorNotation.RGB&&e.colorNotation!==exports.ColorNotation.HEX&&(r=o?XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(e).channels):n.xyz.XYZ_D50_to_sRGB(colorData_to_XYZ_D50(e).channels));const s=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[0])))),l=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[1])))),i=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[2])))),u=[a.TokenType.CloseParen,")",-1,-1,void 0],c=[a.TokenType.Whitespace," ",-1,-1,void 0],p=[a.TokenType.Comma,",",-1,-1,void 0],N=[new t.TokenNode([a.TokenType.Number,s.toString(),-1,-1,{value:r[0],type:a.NumberType.Integer}]),new t.TokenNode(p),new t.TokenNode(c),new t.TokenNode([a.TokenType.Number,l.toString(),-1,-1,{value:r[1],type:a.NumberType.Integer}]),new t.TokenNode(p),new t.TokenNode(c),new t.TokenNode([a.TokenType.Number,i.toString(),-1,-1,{value:r[2],type:a.NumberType.Integer}])];if("number"==typeof e.alpha){const o=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(o,4)?new t.FunctionNode([a.TokenType.Function,"rgb(",-1,-1,{value:"rgb"}],u,N):new t.FunctionNode([a.TokenType.Function,"rgba(",-1,-1,{value:"rgba"}],u,[...N,new t.TokenNode(p),new t.TokenNode(c),new t.TokenNode([a.TokenType.Number,toPrecision(o,4).toString(),-1,-1,{value:e.alpha,type:a.NumberType.Number}])])}return new t.FunctionNode([a.TokenType.Function,"rgba(",-1,-1,{value:"rgba"}],u,[...N,new t.TokenNode(p),new t.TokenNode(c),e.alpha])};
