import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _5b26271b = () => interopDefault(import('../pages/about-us.vue' /* webpackChunkName: "pages/about-us" */))
const _91a7d570 = () => interopDefault(import('../pages/account-delete.vue' /* webpackChunkName: "pages/account-delete" */))
const _af0c0246 = () => interopDefault(import('../pages/cart.vue' /* webpackChunkName: "pages/cart" */))
const _675232cd = () => interopDefault(import('../pages/certification.vue' /* webpackChunkName: "pages/certification" */))
const _269398fa = () => interopDefault(import('../pages/checkout.vue' /* webpackChunkName: "pages/checkout" */))
const _41009773 = () => interopDefault(import('../pages/contact.vue' /* webpackChunkName: "pages/contact" */))
const _4ada5756 = () => interopDefault(import('../pages/CourseCategory.vue' /* webpackChunkName: "pages/CourseCategory" */))
const _5f17451a = () => interopDefault(import('../pages/CourseDetails.vue' /* webpackChunkName: "pages/CourseDetails" */))
const _3aa90b0b = () => interopDefault(import('../pages/courses.vue' /* webpackChunkName: "pages/courses" */))
const _189a7db2 = () => interopDefault(import('../pages/dashboard.vue' /* webpackChunkName: "pages/dashboard" */))
const _7058041b = () => interopDefault(import('../pages/error.vue' /* webpackChunkName: "pages/error" */))
const _281628e9 = () => interopDefault(import('../pages/faq.vue' /* webpackChunkName: "pages/faq" */))
const _eed886d6 = () => interopDefault(import('../pages/get-discount.vue' /* webpackChunkName: "pages/get-discount" */))
const _68f1b605 = () => interopDefault(import('../pages/gp-academy.vue' /* webpackChunkName: "pages/gp-academy" */))
const _60480da6 = () => interopDefault(import('../pages/inspire.vue' /* webpackChunkName: "pages/inspire" */))
const _138cee08 = () => interopDefault(import('../pages/login.vue' /* webpackChunkName: "pages/login" */))
const _4d173a28 = () => interopDefault(import('../pages/notification.vue' /* webpackChunkName: "pages/notification" */))
const _d5283316 = () => interopDefault(import('../pages/password-change.vue' /* webpackChunkName: "pages/password-change" */))
const _292eadd8 = () => interopDefault(import('../pages/privacy-policy.vue' /* webpackChunkName: "pages/privacy-policy" */))
const _4928107c = () => interopDefault(import('../pages/profile.vue' /* webpackChunkName: "pages/profile" */))
const _1169b025 = () => interopDefault(import('../pages/search.vue' /* webpackChunkName: "pages/search" */))
const _1c693a22 = () => interopDefault(import('../pages/search-certificate.vue' /* webpackChunkName: "pages/search-certificate" */))
const _4ee5ff68 = () => interopDefault(import('../pages/SingleTeacherCourse.vue' /* webpackChunkName: "pages/SingleTeacherCourse" */))
const _552d00d8 = () => interopDefault(import('../pages/student-feedback.vue' /* webpackChunkName: "pages/student-feedback" */))
const _396eede5 = () => interopDefault(import('../pages/term-of-use.vue' /* webpackChunkName: "pages/term-of-use" */))
const _40927405 = () => interopDefault(import('../pages/verified.vue' /* webpackChunkName: "pages/verified" */))
const _f07aaebc = () => interopDefault(import('../pages/wishList.vue' /* webpackChunkName: "pages/wishList" */))
const _0e735436 = () => interopDefault(import('../pages/category/_slug.vue' /* webpackChunkName: "pages/category/_slug" */))
const _46a01068 = () => interopDefault(import('../pages/certificate/_slug/index.vue' /* webpackChunkName: "pages/certificate/_slug/index" */))
const _1cf21038 = () => interopDefault(import('../pages/classroom/_slug/index.vue' /* webpackChunkName: "pages/classroom/_slug/index" */))
const _61153388 = () => interopDefault(import('../pages/course-details/_slug.vue' /* webpackChunkName: "pages/course-details/_slug" */))
const _0eaffe8d = () => interopDefault(import('../pages/payment-success/_slug/index.vue' /* webpackChunkName: "pages/payment-success/_slug/index" */))
const _7b4d3bd3 = () => interopDefault(import('../pages/purchase-verify/_slug.vue' /* webpackChunkName: "pages/purchase-verify/_slug" */))
const _f5558788 = () => interopDefault(import('../pages/purchase/_slug/index.vue' /* webpackChunkName: "pages/purchase/_slug/index" */))
const _3b0d509e = () => interopDefault(import('../pages/registration/_slug.vue' /* webpackChunkName: "pages/registration/_slug" */))
const _1b86b04a = () => interopDefault(import('../pages/teacher-courses/_slug.vue' /* webpackChunkName: "pages/teacher-courses/_slug" */))
const _2c91e5e5 = () => interopDefault(import('../pages/index.vue' /* webpackChunkName: "pages/index" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/about-us",
    component: _5b26271b,
    name: "about-us"
  }, {
    path: "/account-delete",
    component: _91a7d570,
    name: "account-delete"
  }, {
    path: "/cart",
    component: _af0c0246,
    name: "cart"
  }, {
    path: "/certification",
    component: _675232cd,
    name: "certification"
  }, {
    path: "/checkout",
    component: _269398fa,
    name: "checkout"
  }, {
    path: "/contact",
    component: _41009773,
    name: "contact"
  }, {
    path: "/CourseCategory",
    component: _4ada5756,
    name: "CourseCategory"
  }, {
    path: "/CourseDetails",
    component: _5f17451a,
    name: "CourseDetails"
  }, {
    path: "/courses",
    component: _3aa90b0b,
    name: "courses"
  }, {
    path: "/dashboard",
    component: _189a7db2,
    name: "dashboard"
  }, {
    path: "/error",
    component: _7058041b,
    name: "error"
  }, {
    path: "/faq",
    component: _281628e9,
    name: "faq"
  }, {
    path: "/get-discount",
    component: _eed886d6,
    name: "get-discount"
  }, {
    path: "/gp-academy",
    component: _68f1b605,
    name: "gp-academy"
  }, {
    path: "/inspire",
    component: _60480da6,
    name: "inspire"
  }, {
    path: "/login",
    component: _138cee08,
    name: "login"
  }, {
    path: "/notification",
    component: _4d173a28,
    name: "notification"
  }, {
    path: "/password-change",
    component: _d5283316,
    name: "password-change"
  }, {
    path: "/privacy-policy",
    component: _292eadd8,
    name: "privacy-policy"
  }, {
    path: "/profile",
    component: _4928107c,
    name: "profile"
  }, {
    path: "/search",
    component: _1169b025,
    name: "search"
  }, {
    path: "/search-certificate",
    component: _1c693a22,
    name: "search-certificate"
  }, {
    path: "/SingleTeacherCourse",
    component: _4ee5ff68,
    name: "SingleTeacherCourse"
  }, {
    path: "/student-feedback",
    component: _552d00d8,
    name: "student-feedback"
  }, {
    path: "/term-of-use",
    component: _396eede5,
    name: "term-of-use"
  }, {
    path: "/verified",
    component: _40927405,
    name: "verified"
  }, {
    path: "/wishList",
    component: _f07aaebc,
    name: "wishList"
  }, {
    path: "/category/:slug?",
    component: _0e735436,
    name: "category-slug"
  }, {
    path: "/certificate/:slug",
    component: _46a01068,
    name: "certificate-slug"
  }, {
    path: "/classroom/:slug",
    component: _1cf21038,
    name: "classroom-slug"
  }, {
    path: "/course-details/:slug?",
    component: _61153388,
    name: "course-details-slug"
  }, {
    path: "/payment-success/:slug",
    component: _0eaffe8d,
    name: "payment-success-slug"
  }, {
    path: "/purchase-verify/:slug?",
    component: _7b4d3bd3,
    name: "purchase-verify-slug"
  }, {
    path: "/purchase/:slug",
    component: _f5558788,
    name: "purchase-slug"
  }, {
    path: "/registration/:slug?",
    component: _3b0d509e,
    name: "registration-slug"
  }, {
    path: "/teacher-courses/:slug?",
    component: _1b86b04a,
    name: "teacher-courses-slug"
  }, {
    path: "/",
    component: _2c91e5e5,
    name: "index"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
