"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeOptions = void 0;
const os_1 = require("os");
const loader_utils_1 = require("loader-utils");
const validate_options_1 = require("./validate-options");
const normalizePatterns = (patterns) => Array.isArray(patterns) ? patterns : [patterns];
const coerceContentEOL = (content) => (content.endsWith(os_1.EOL) ? content : `${content}${os_1.EOL}`);
const getResourceContent = ({ content }) => coerceContentEOL(content);
const normalizeInjector = (injector) => {
    if (typeof injector === 'undefined' || injector === 'prepend') {
        return (source, resources) => resources.map(getResourceContent).join('') + source;
    }
    if (injector === 'append') {
        return (source, resources) => source + resources.map(getResourceContent).join('');
    }
    return injector;
};
const normalizeOptions = (ctx) => {
    const options = (0, loader_utils_1.getOptions)(ctx);
    (0, validate_options_1.validateOptions)(options);
    const { patterns, injector, globOptions = {}, resolveUrl = true } = options;
    return {
        patterns: normalizePatterns(patterns),
        injector: normalizeInjector(injector),
        globOptions,
        resolveUrl,
    };
};
exports.normalizeOptions = normalizeOptions;
//# sourceMappingURL=normalize-options.js.map